#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################


#----------------------! do not edit below this line !-----------------------

use strict;

my (
	$inited,
);

#----------------------------------! subs !----------------------------------

sub	catselect {
	my $selected = shift(@_);
	my $options = qq[\t<option value="">-\n];
	foreach my $cat (@cats) {
		$options .= qq[\t<option value="$cat"].
			($selected eq $cat ? " selected" : "").
			">$cat\n";
	}
	return $options;
}

sub	dumptmpl {
	open (F, "< $cf{datapath}/intpages/$_[0].tmpl")
		|| err("Could not open $_[0].tmpl");
	my $data = join("", <F>) || "";
	close F;
	
	study $data;

	$cf{done} = $cf{done} ? qq[<font color="#ff0000"><b>$cf{done}</b></font><hr><br>] : "";
	foreach (keys %cf) {
		$data =~ s/%$_%/$cf{$_}/g;
	}
	foreach (keys %cgi) {
		$data =~ s/%$_%/$cgi{$_}/g;
	}

	return $data;
}

sub	prthtml {
	inithtml();
	my $tmpl = shift	|| err("No template specified to print?");
	my $html = dumptmpl($tmpl);
	print $html;
}

sub	inithtml {
        return if $inited;
	$inited++;
	print "Content-type: text/html\n\n";
}

sub	setcookie {
	print "Set-Cookie: $_[0]\n";
}

sub	hash {
	my $pass = shift || return '!';
	my $salt;
	if (!defined ($salt = shift)) {
		my $chars = join("",(map { $_ } 'a'..'z','A'..'Z',0..9,'.','/'));
		$salt = (join '', map { substr($chars, rand(length $chars), 1) } 1..2);
	}

	return crypt($pass, $salt);
}

sub	err {
	$cf{errmsg} = shift;
	$cf{cgiurl} ||= "admin.cgi";
	fatal($cf{errmsg}) if ($cf{errmsg} =~ /err\.tmpl$/);
	my $html = dumptmpl("err");
	inithtml();
	print $html;
	exit;
}

sub	fatal {
	inithtml();
	my $errmsg = shift() . " datapath = $cf{datapath}";
	print <<EOT;
	<html><head><title>Fatal Error!</title></head>
	<body bgcolor="#FFFFFF" text="#000000">
	<blockquote><blockquote>
	<font face="Verdana, Arial, sans-serif" size=2>
	<p><b>FATAL</b>:<br>
	<blockquote>o<font color=red> $errmsg</font><br>
	</blockquote><br>
        <hr>
	<a href="javascript:window.history.go(-1)">Back</a><br>
	<a href="$cf{cgiurl}/mailto.cgi">Mail admin</a><br>
	<a href="/">Site index</a><br>
	</p></font>
	</blockquote></blockquote>
	</body>
	</html>
EOT
        exit;
}

sub	getcgi {
	my $query;
	if ($ENV{REQUEST_METHOD} =~ /post/i) {
		read(STDIN, $query, $ENV{CONTENT_LENGTH})
	} else {
		$query = $ENV{QUERY_STRING}
	}
	if ($ENV{REQUEST_METHOD} !~ /post/i || $ENV{CONTENT_TYPE} =~ /x-www-form-urlencoded/) {
		$query =~ tr/+/ /;
		foreach (split(/&/, $query)) {
			my ($item, $value) = split(/=/);
			map { s/%([a-f0-9]{2})/pack("C", hex($1))/egi } ($item, $value);
			$value =~ tr/"/'/;
			$cgi{$item} = $value;
		}
	} elsif ($ENV{CONTENT_TYPE} =~ /multipart\/form-data.+boundary=(\S+)/) {
		my $boundary = $1;
		foreach (grep { /[a-z]/ } split(/(--)?${boundary}(--)?[\n\r]+/, $query)) {
			my ($headers, $content) = split(/\n\r?\s*\n\r?/, $_, 2);
			my $ct = (grep { /^content-disposition/i } split(/[\n\r]/, $headers))[0];
			$ct =~ /\bname=(["'])(.+?)\1/
				|| $ct =~ /\b(name)=([^'"\s]\S+)\b/ and my $name = $2;
			$content =~ s/\r\n?$//;
			if (/\bfilename=(["'])(.+?)\1/ || /\b(filename)=([^'"\s]\S+)\b/) {
				$cgi{$name} = {
					name	=> "$2",
					content	=> $content,
				}
			} else {
				$content =~ tr/"/'/;
				$cgi{$name} = $content;
			}
		}
	} elsif ($ENV{CONTENT_TYPE}) {
		err("Invalid content type?");
	}
	foreach my $set (grep { ref($_) eq "HASH" } @_) {
		foreach (keys %{$set}) {
			err("Field not specified: $$set{$_}")
				if !defined $cgi{$_};
		}
	}
}

1;

